/*
 * Decompiled with CFR 0.152.
 */
public class AwtSprite
extends Sprite {
    int deltaHeight;
    int deltaWidth;
    boolean hasAlpha = false;
    int height;
    int offsetX;
    int offsetY;
    int[] raster;
    int width;

    AwtSprite(int width, int height, int[] raster) {
        this.width = width;
        this.height = height;
        this.raster = raster;
        int[] nArray = raster;
        int n = raster.length;
        int n2 = 0;
        while (n2 < n) {
            int pixel = nArray[n2];
            if ((pixel & 0xFF000000) != -16777216) {
                this.hasAlpha = true;
                break;
            }
            ++n2;
        }
    }

    @Override
    public int[] argb(boolean scale) {
        if (scale && (this.getScaleWidth() != this.width || this.getScaleHeight() != this.height)) {
            int scaleWidth = this.getScaleWidth();
            int[] argb = new int[scaleWidth * this.getScaleHeight()];
            int y = 0;
            while (y < this.height) {
                int source = y * this.width;
                int dest = this.offsetX + (y + this.offsetY) * scaleWidth;
                int x = 0;
                while (x < this.width) {
                    argb[dest++] = this.raster[source];
                    ++source;
                    ++x;
                }
                ++y;
            }
            return argb;
        }
        return this.raster;
    }

    @Override
    public void clearOffsets() {
        this.deltaHeight = 0;
        this.offsetY = 0;
        this.deltaWidth = 0;
        this.offsetX = 0;
    }

    @Override
    public void flipHorizontal() {
        int[] raster = this.raster;
        int y = (this.height >> 1) - 1;
        while (y >= 0) {
            int left = y * this.width;
            int right = (this.height - y - 1) * this.width;
            int x = -this.width;
            while (x < 0) {
                int tmp = raster[left];
                raster[left] = raster[right];
                raster[right] = tmp;
                ++left;
                ++right;
                ++x;
            }
            --y;
        }
        int tmp = this.offsetY;
        this.offsetY = this.deltaHeight;
        this.deltaHeight = tmp;
    }

    @Override
    public void flipVertical() {
        int[] raster = this.raster;
        int y = this.height - 1;
        while (y >= 0) {
            int index = y * this.width;
            int max = (y + 1) * this.width;
            while (index < max) {
                int tmp = raster[index];
                raster[index] = raster[--max];
                raster[max] = tmp;
                ++index;
            }
            --y;
        }
        int tmp = this.offsetX;
        this.offsetX = this.deltaWidth;
        this.deltaWidth = tmp;
    }

    @Override
    public int getColour(int x, int y) {
        return this.raster[x + y * this.width];
    }

    @Override
    public int getDeltaHeight() {
        return this.deltaHeight;
    }

    @Override
    public int getDeltaWidth() {
        return this.deltaWidth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getOffsetX() {
        return this.offsetX;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public int getScaleHeight() {
        return this.height + this.offsetY + this.deltaHeight;
    }

    @Override
    public int getScaleWidth() {
        return this.width + this.offsetX + this.deltaWidth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public void offsetColour(int dr, int dg, int db) {
        int index = 1;
        while (index < this.raster.length) {
            int red = this.raster[index] >> 16 & 0xFF;
            if ((red += dr) < 0) {
                red = 0;
            } else if (red > 255) {
                red = 255;
            }
            int green = this.raster[index] >> 8 & 0xFF;
            if ((green += dg) < 0) {
                green = 0;
            } else if (green > 255) {
                green = 255;
            }
            int blue = this.raster[index] >> 0 & 0xFF;
            if ((blue += db) < 0) {
                blue = 0;
            } else if (blue > 255) {
                blue = 255;
            }
            this.raster[index] = this.raster[index] & 0xFF000000 | red << 16 | green << 8 | blue;
            ++index;
        }
    }

    @Override
    public void rotateClockwise() {
        int[] rotated = new int[this.width * this.height];
        int index = 0;
        int x = 0;
        while (x < this.width) {
            int y = this.height - 1;
            while (y >= 0) {
                rotated[index++] = this.raster[x + y * this.width];
                --y;
            }
            ++x;
        }
        this.raster = rotated;
        int tmp = this.offsetY;
        this.offsetY = this.offsetX;
        this.offsetX = this.deltaHeight;
        this.deltaHeight = this.deltaWidth;
        this.deltaWidth = tmp;
        tmp = this.height;
        this.height = this.width;
        this.width = tmp;
    }

    @Override
    public void scale(int border) {
        int scaleWidth = this.getScaleWidth();
        int scaleHeight = this.getScaleHeight();
        if (this.width != scaleWidth || this.height != scaleHeight) {
            int dh;
            int dy;
            int dw;
            int dx = border;
            if (dx > this.offsetX) {
                dx = this.offsetX;
            }
            if ((dw = border) + this.offsetX + this.width > scaleWidth) {
                dw = scaleWidth - this.offsetX - this.width;
            }
            if ((dy = border) > this.offsetY) {
                dy = this.offsetY;
            }
            if ((dh = border) + this.offsetY + this.height > scaleHeight) {
                dh = scaleHeight - this.offsetY - this.height;
            }
            int width = this.width + dx + dw;
            int height = this.height + dy + dh;
            int[] raster = new int[width * height];
            this.hasAlpha = false;
            int y = 0;
            while (y < this.height) {
                int source = y * this.width;
                int dest = (y + dy) * width + dx;
                int x = 0;
                while (x < this.width) {
                    if ((this.raster[source] & 0xFF000000) != -16777216) {
                        this.hasAlpha = true;
                    }
                    raster[dest++] = this.raster[source++];
                    ++x;
                }
                ++y;
            }
            this.offsetX -= dx;
            this.offsetY -= dy;
            this.deltaWidth -= dw;
            this.deltaHeight -= dh;
            this.width = width;
            this.height = height;
            this.raster = raster;
        }
    }

    @Override
    public void setBorderColour(int colour) {
        int index = 0;
        this.hasAlpha = false;
        int[] recoloured = new int[this.width * this.height];
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                int current = this.raster[index];
                if ((current & 0xFF000000) == 0) {
                    if (x > 0 && (this.raster[index - 1] & 0xFF000000) != 0) {
                        current = colour;
                    } else if (y > 0 && (this.raster[index - this.width] & 0xFF000000) != 0) {
                        current = colour;
                    } else if (x < this.width - 1 && (this.raster[index + 1] & 0xFF000000) != 0) {
                        current = colour;
                    } else if (y < this.height - 1 && (this.raster[index + this.width] & 0xFF000000) != 0) {
                        current = colour;
                    }
                }
                if ((current & 0xFF000000) != -16777216) {
                    this.hasAlpha = true;
                }
                recoloured[index++] = current;
                ++x;
            }
            ++y;
        }
        this.raster = recoloured;
    }

    @Override
    public void setShadowColour(int colour) {
        int y = this.height - 1;
        while (y > 0) {
            int index = y * this.width;
            int x = this.width - 1;
            while (x > 0) {
                if ((this.raster[x + index] & 0xFF000000) == 0 && (this.raster[x + index - 1 - this.width] & 0xFF000000) != 0) {
                    this.raster[x + index] = colour;
                }
                --x;
            }
            --y;
        }
    }

    @Override
    public int[] getPallet() {
        return null;
    }

    @Override
    public byte[] getAlphas() {
        return null;
    }
}

